//
//  ViewController.m
//  Citizen PSample 2
//
//  Created by Member Driver on 12/11/19.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "ViewController.h"

@implementation ViewController

@synthesize editText_Address_Wifi;

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.

    // manage keyboard
    editText_Address_Wifi.returnKeyType = UIReturnKeyDone;
    editText_Address_Wifi.delegate = self;
    
    editText_Address_Wifi.text = @"";       // clear IP address

    // make instance
    escp = [[ESCPOSPrinter alloc] init];
}

- (void)dealloc
{
    // release object
    [editText_Address_Wifi release];
    [segmentPortType release];
    
    [super dealloc];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    
    // release
    [escp release];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        //return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
        return YES;
    } else {
        return YES;
    }
}

- (void)messageBox:(NSString *)message withTitle:(NSString *)title withAutoDismiss:(BOOL)dismiss
{
    if (!dismiss)
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:message delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [alert show];
        [alert release];
    }
    else
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:message delegate:nil cancelButtonTitle:nil otherButtonTitles:nil];
        [alert show];
        [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:1.0]];    // wait 1.0 sec
        [alert dismissWithClickedButtonIndex:0 animated:NO];
        [alert release];
    }
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    [editText_Address_Wifi resignFirstResponder];
    return YES;
}

- (IBAction)onClick_button_connect:(id)sender
{
    // get address
    NSString *addr = editText_Address_Wifi.text;
    
    // connect
    [self connect:escp withConnectType:CMP_PORT_WiFi withAddress:addr];
}

- (IBAction)onClick_button_disconnect:(id)sender
{
    [self disconnect:escp];
}

- (IBAction)onClick_button_print:(id)sender
{
    [self print:escp];
}

- (IBAction)onClick_button_printerCheck:(id)sender
{
    [self printerCheck:escp];
}

- (BOOL)connect:(id)posPtr withConnectType:(int)connectType withAddress:(NSString*)addr
{
    int result;
    BOOL bRet = FALSE;
    
    if (nil == posPtr)
    {
        [self messageBox:@"ESCPOSPrinter() : Instance is not created" withTitle:@"Error" withAutoDismiss:TRUE];
        return bRet;
    }
    
    // connect
    if (0 == segmentPortType.selectedSegmentIndex)
    {
        result = [posPtr connect:CMP_PORT_BLUETOOTH withAddrress:addr];
    }
    else
    {
        result = [posPtr connect:CMP_PORT_WiFi withAddrress:addr];
    }
    if (CMP_SUCCESS == result)
    {
        bRet = TRUE;
        [self messageBox:@"connect() : Success" withTitle:@"Success" withAutoDismiss:TRUE];
    }
    else
    {
        // connect error
        NSString *message = [NSString stringWithFormat:@"Connect() error : %d", result];
        [self messageBox:message withTitle:@"Error" withAutoDismiss:TRUE];
    }
    return bRet;
}

- (BOOL)disconnect:(id)posPtr
{
    int result;
    BOOL bRet = FALSE;

    if (nil == posPtr)
    {
        [self messageBox:@"ESCPOSPrinter() : Instance is not created" withTitle:@"Error" withAutoDismiss:TRUE];
        return bRet;
    }
    
    // disconnect
    result = [posPtr disconnect];
    if (CMP_SUCCESS == result)
    {
        bRet = TRUE;
        [self messageBox:@"disconnect() : Success" withTitle:@"Success" withAutoDismiss:TRUE];
    }
    else
    {
        NSString *message = [NSString stringWithFormat:@"disonnect() error : %d", result];
        [self messageBox:message withTitle:@"Error" withAutoDismiss:TRUE];
    }
    return bRet;
}

- (BOOL)printerCheck:(id)posPtr
{
    int result;
    BOOL bRet = FALSE;
    NSMutableString *msg = [[NSMutableString alloc] initWithString:@""];
    
    if (nil == posPtr)
    {
        [msg appendString:@"ESCPOSPrinter() : Instance is not created"];
    }
    else
    {
        // printer check
        result = [posPtr printerCheck];
        if (CMP_SUCCESS == result)
        {
            [msg appendString:@"\nprinterCheck() : Success\n"];
            
            // get status
            int status = [posPtr status];
            if (CMP_STS_NORMAL == status)
            {
                // no error
                bRet = TRUE;
                [msg appendString:@"\n\t * Normal ( No Error )"];
            }
            else
            {
                if ((CMP_STS_COVER_OPEN & status) > 0)
                {
                    // cover open
                    [msg appendString:@"\n\t * Cover Open"];
                }
                if ((CMP_STS_PAPER_EMPTY & status) > 0)
                {
                    // cover open
                    [msg appendString:@"\n\t * Paper Empty"];
                }
                if ((CMP_STS_PRINTEROFF & status) > 0)
                {
                    // cover open
                    [msg appendString:@"\n\t * Printer Offline"];
                }
            }
        }
        else
        {
            // printCheck() error
            [msg appendFormat:@"\nprintCheck() error : %d", result];
        }
        if (![msg isEqualToString:@""])
        {
            [self messageBox:msg withTitle:@"Information" withAutoDismiss:FALSE];
        }
    }
    [msg release];
    return bRet;
}

- (BOOL)print:(id)posPtr
{
    int result;
    BOOL bRet = FALSE;
    
    if (nil == posPtr)
    {
        [self messageBox:@"ESCPOSPrinter() : Instance is not created" withTitle:@"Error" withAutoDismiss:TRUE];
        return bRet;
    }
    
    // printer check
    result = [posPtr printerCheck];
    if (CMP_SUCCESS != result)
    {
        NSString *message1 = [NSString stringWithFormat:@"printerCheck() error : %d", result];
        [self messageBox:message1 withTitle:@"Error" withAutoDismiss:TRUE];
        return bRet;
    }

    // get status
    int status = [posPtr status];
    if (CMP_STS_NORMAL != status)
    {
        NSString *message1 = [NSString stringWithFormat:@"status() error : %d", status];
        [self messageBox:message1 withTitle:@"Error" withAutoDismiss:TRUE];
        return bRet;
    }
    
    // character set
    result = [posPtr setEncoding:NSISOLatin1StringEncoding]; // latin-1
    //result = [posPtr setEncoding:NSShiftJISStringEncoding];    // japanese shift-jis
    if (CMP_SUCCESS != result)
    {
        NSString *message1 = [NSString stringWithFormat:@"setEncoding() error : %d", result];
        [self messageBox:message1 withTitle:@"Error" withAutoDismiss:TRUE];
        return bRet;
    }
    
    // start transaction (batch)
    result = [posPtr transactionPrint:CMP_TP_TRANSACTION];
    if (CMP_SUCCESS != result)
    {
        NSString *message2 = [NSString stringWithFormat:@"transactionPrint() error : %d", result];
        [self messageBox:message2 withTitle:@"Error" withAutoDismiss:TRUE];
        return bRet;
    }
    
    // printText
    NSString *appName = [NSString stringWithFormat:@"%@", [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleDisplayName"]];
    NSString *prndata = [NSString stringWithFormat:@"%@\n\n- Sample Print -\n1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", appName];
    result = [posPtr printText:prndata withAlignment:CMP_ALIGNMENT_CENTER withAttribute:CMP_FNT_DEFAULT withTextSize:CMP_TXT_1WIDTH|CMP_TXT_1HEIGHT];
    if (CMP_SUCCESS != result)
    {
        NSString *message3 = [NSString stringWithFormat:@"printText() error : %d", result];
        [self messageBox:message3 withTitle:@"Error" withAutoDismiss:TRUE];
        goto TR_ERROR;
    }

    // partical cut with pre-feed
    result = [posPtr cutPaper:CMP_CUT_PARTIAL_PREFEED];
    if (CMP_SUCCESS != result)
    {
        NSString *message4 = [NSString stringWithFormat:@"cutPaper() error : %d", result];
        [self messageBox:message4 withTitle:@"Error" withAutoDismiss:TRUE];
        goto TR_ERROR;
    }
    
    // end transaction (batch)
    result = [posPtr transactionPrint:CMP_TP_NORMAL];
    if (CMP_SUCCESS != result)
    {
        NSString *message5 = [NSString stringWithFormat:@"transactionPrint() error : %d", result];
        [self messageBox:message5 withTitle:@"Error" withAutoDismiss:TRUE];
        goto TR_ERROR;
    }
    bRet = TRUE;
    return bRet;
    
TR_ERROR:
    // Clear all buffered output data by tranzactionPrint.
    [escp clearOutput];
    return bRet;
}

@end
